// SerialBuffer.cpp: implementation of the CSerialBuffer class.
//
//////////////////////////////////////////////////////////////////////

#include "SerialBuffer.h"
#include "SerialCommHelper.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSerialBuffer::CSerialBuffer()
{
	Init();
}
void CSerialBuffer::Init()
{
	::InitializeCriticalSection(&m_csLock);
	m_abLockAlways = true;
	m_iCurPos = 0;
	m_alBytesUnRead = 0;
	m_szInternalBuffer.erase();

}
CSerialBuffer::~CSerialBuffer()
{
	::DeleteCriticalSection(&m_csLock);

}

void CSerialBuffer::ClearAndReset(HANDLE& hEventToReset)
{
	m_szInternalBuffer.erase();
	m_alBytesUnRead = 0;
	m_iCurPos = 0;
	::ResetEvent(hEventToReset);

}

void CSerialBuffer::AddData(char ch)
{
	//ATLTRACE6 (_T("CSerialBuffer : (tid:%d) AddData(char) called "), GetCurrentThreadId ());	
	m_szInternalBuffer += ch;
	m_alBytesUnRead += 1;

}

void CSerialBuffer::AddData(std::string& szData, int iLen)
{
	//ATLTRACE6 (_T("CSerialBuffer : (tid:%d) AddData(%s,%d) called "), GetCurrentThreadId (),szData.c_str (),iLen);	
	m_szInternalBuffer.append(szData.c_str(), iLen);
	m_alBytesUnRead += iLen;

}

void CSerialBuffer::AddData(char* strData, int iLen)
{
	//ATLTRACE6 (_T("CSerialBuffer : (tid:%d) AddData(char*,%d) called "), GetCurrentThreadId (),iLen);	
	//ASSERT ( strData != NULL );
	m_szInternalBuffer.append(strData, iLen);
	m_alBytesUnRead += iLen;

}

void CSerialBuffer::AddData(std::string& szData)
{
	//ATLTRACE6 (_T("CSerialBuffer : (tid:%d) AddData(%s) called "), GetCurrentThreadId (),szData.c_str () );	
	m_szInternalBuffer += szData;
	m_alBytesUnRead += szData.size();

}
void CSerialBuffer::Flush()
{
	LockBuffer();
	m_szInternalBuffer.erase();
	m_alBytesUnRead = 0;
	m_iCurPos = 0;
	UnLockBuffer();
}

long	 CSerialBuffer::Read_N(std::string& szData, long  alCount, HANDLE& hEventToReset)
{
	//ATLTRACE6 (_T("CSerialBuffer : (tid:%d) Read_N() called "), GetCurrentThreadId ());	
	//ASSERT ( hEventToReset != INVALID_HANDLE_VALUE ) ;


	LockBuffer();
	long alTempCount = min(alCount, m_alBytesUnRead);
	long alActualSize = GetSize();

	szData.append(m_szInternalBuffer, m_iCurPos, alTempCount);

	m_iCurPos += alTempCount;

	m_alBytesUnRead -= alTempCount;
	if (m_alBytesUnRead == 0)
	{
		ClearAndReset(hEventToReset);
	}

	UnLockBuffer();
	//ATLTRACE6 (_T("CSerialBuffer : (tid:%d) Read_N returned %d bytes (data:%s)  "), GetCurrentThreadId (),alTempCount,((szData)).c_str());	
	return alTempCount;
}
